/////////////////////////////////////////////////////////////////////////////////////////////////////
//																																	//
//	Coded by www.decotechpro.com, all rights reserved.  Created: 2016-03-17  Modified: 2016-08-08	//
//																																	//
// ThreeTimers.h : Main header of the application.																	//
//																																	//
/////////////////////////////////////////////////////////////////////////////////////////////////////

//#include "ThreeTimers.h"
#pragma once

#include "resource.h"
#include "TT_Pixel.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////
//	Instruction to build the ENGLISH application:
//	1- In "Configuration Properties" --> "Resources" --> "General" --> "Preprocessor Definitions": Rename _DT_LANG_# to _DT_LANG_1.
//	2- In "Resource View" --> "ThreeTimers" --> "ThreeTimers.rc" --> "String Table" : Move temporarily the "String Table [French (Canada)]" to another project to not lose it.
//	3- Save all then compile.
//	4- In "Resource View" --> "ThreeTimers" --> "ThreeTimers.rc" --> "String Table" : Bring back the "String Table [French (Canada)]" then save all.
//---------------------------------------------------------------------------------------------------
//	Instruction to build the FRENCH application:
//	1- In "Configuration Properties" --> "Resources" --> "General" --> "Preprocessor Definitions": Rename _DT_LANG_# to _DT_LANG_0.
//	2- In "Resource View" --> "ThreeTimers" --> "ThreeTimers.rc" --> "String Table" : Move temporarily the "String Table [English (U.S.)]" to another project to not lose it.
//	3- Save all then compile.
//	4- In "Resource View" --> "ThreeTimers" --> "ThreeTimers.rc" --> "String Table" : Bring back the "String Table [English (U.S.)]" then save all.
//	5- Rename "ThreeTimers.exe" to "TroisMinuteries.exe".
/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////

#define	TT_CDERR_USER_CANCEL					0x0000

#define	TT_FONT_NAME__Segoe_UI				_T("Segoe UI")
#define	TT_FONT_FILE_SEGOEUI_TTF			_T("SegoeUI.ttf")
#define  TT_WINDOWS_FILE__Notepad_exe		_T("Notepad.exe")
#define  TT_WINDOWS_WINCLASS_ID__Notepad	_T("Notepad")		//	Only tested on Windows 7 but probably also works on Vista and XP.

#define  TT_EXTENSION__exe					_T(".exe")
#define  TT_EXTENSION__lnk					_T(".lnk")
#define  TT_EXTENSION__wav					_T(".wav")

#define	TT_TimerLabel_MaxBufCnt			(30 + EOS_CHAR_COUNT)
#define	TT_ExtSndLabel_MaxBufCnt		(30 + EOS_CHAR_COUNT)
#define	TT_ExtSndFileName_MaxBufCnt	MAX_PATH
#define	TT_OpenFileLabel_MaxBufCnt		(30 + EOS_CHAR_COUNT)
#define	TT_OpenFileName_MaxBufCnt		(100 * MAX_PATH)
#define	TT_TimerValue_MaxBufCnt			(10 + EOS_CHAR_COUNT)

#define 	TT_TimerValue_One_Hour		3600000		//	Value in milliseconds equals to 1 hour.
#define 	TT_TimerValue_One_Minute	60000			//	Value in milliseconds equals to 1 minute.
#define 	TT_TimerValue_One_Second	1000			//	Value in milliseconds equals to 1 second.
#define 	TT_TimerValue_Min				1000			//	Value in milliseconds equals to 1 second.
#define 	TT_TimerValue_Max				2145600000	//	Value in milliseconds equals to 596 hours.

//------------------------------------------------

#define	TT_IDC_Cmd__STOP_1				(WM_USER + 0x7BFF - 0)		//	Used to indicate that the timer #1 event has been triggered.
#define	TT_IDC_Cmd__STOP_2				(WM_USER + 0x7BFF - 1)		//	Used to indicate that the timer #2 event has been triggered.
#define	TT_IDC_Cmd__STOP_3				(WM_USER + 0x7BFF - 2)		//	Used to indicate that the timer #3 event has been triggered.
#define	TT_IDC_Cmd__Ask_Exit				(WM_USER + 0x7BFF - 3)		//	Used to indicate to exit the application.
#define	TT_IDC_Cmd__Ask_Exit_Funny		(WM_USER + 0x7BFF - 4)		//	Used to indicate to exit the application with a funny sound.

//------------------------------------------------

#define 	TT_IDM_ADJ_TIMERS_LABELS			IDS_MENU_ADJ_TIMERS_LABELS
#define 	TT_IDM_ADJ_EXTERNAL_SND				IDS_MENU_ADJ_EXTERNAL_SND
#define 	TT_IDM_ADJ_OPEN_FILE					IDS_MENU_ADJ_OPEN_FILE
#define 	TT_IDM_ADJ_SETTINGS					IDS_MENU_ADJ_SETTINGS
#define 	TT_IDM_SAVE_CUR_SETTINGS			IDS_MENU_SAVE_CUR_SETTINGS
#define 	TT_IDM_CREATE_DESKTOP_SHORTCUT	IDS_MENU_CREATE_DESKTOP_SHORTCUT
#define 	TT_IDM_ABOUT							IDS_MENU_ABOUT
#define 	TT_IDM_EXIT								IDS_MENU_EXIT
#define 	TT_IDM_EXIT_FUNNY						IDS_MENU_EXIT_FUNNY
#define 	TT_IDM_TIMERS_LABELS_RESET			IDS_MENU_TIMERS_LABELS_RESET
#define 	TT_IDM_TIMERS_LABELS_FILL			IDS_MENU_TIMERS_LABELS_FILL
#define 	TT_IDM_EXT_SND_RESET					IDS_MENU_EXT_SND_RESET
#define 	TT_IDM_EXT_SND_FILL					IDS_MENU_EXT_SND_FILL
#define 	TT_IDM_OPEN_FILE_RESET				IDS_MENU_OPEN_FILE_RESET
#define 	TT_IDM_OPEN_FILE_FILL				IDS_MENU_OPEN_FILE_FILL
#define 	TT_IDM_OTHER_SETTINGS_RESET		IDS_MENU_OTHER_SETTINGS_RESET
#define 	TT_IDM_MODIFY_TIMER_LABEL			IDS_MENU_MODIFY_TIMER_LABEL
#define 	TT_IDM_TIMER_LABEL_RESET			IDS_MENU_TIMER_LABEL_RESET
#define 	TT_IDM_RESET_TIMER_ICON				IDS_MENU_RESET_TIMER_ICON

#define 	TT_IDM_CloseMenu						IDS_MENU_CLOSE
#define	TT_IDM_Error							-1		//	Error while creating the Popup Menu.
#define	TT_IDM_NoMenu							0		//	No Popup Menu available at the specified position or cancelled by the user.

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////

extern const UINT_PTR		TT_cunpTimerIdEvent;
extern const DWORD			TT_cdwTimerElapse;					//	In milliseconds.

extern const TCHAR * const	TT_cpcszUniqueClassName_ThreeTimers_ModifyTimerLabelTinyWnd;

//---------------------------------------------------------------------------------------------------

extern HINSTANCE				TT_hInst;								// Current instance.
extern UINT_PTR				TT_unpTimerIdEven;
extern HANDLE					TT_hMemFont_SegoeUI_TTF;
extern unsigned __int64		TT_un64AppFileVersion;
extern unsigned __int64		TT_un64AppProductVersion;
extern TCHAR					TT_szModuleFileName[MAX_PATH];	// Read only.
extern TCHAR					TT_szStartingFolder[MAX_PATH];	// Read only.
extern bool						TT_bIsCoInitializeExFnctCalled;
extern bool						TT_bIsFlashWndContinuously;
extern bool						TT_bIsCalledFromEnterKey;
extern HCURSOR					TT_hCursorClick_LXR;
extern CString					TT_strREG_KEY__ADELUC_TTn;			//	Created with 'TT_REG_KEY__ADELUC_TTn'.

//---------------------------------------------------------------------------------------------------

typedef HRESULT (WINAPI * PFN_DwmIsCompositionEnabled)( __out BOOL * isEnabled );
typedef HRESULT (WINAPI * PFN_DwmGetWindowAttribute  )( __in  HWND hwnd, __in  DWORD dwAttribute, __out PVOID pvAttribute, DWORD cbAttribute );

extern HINSTANCE							TT_hDwmApiDll;
extern PFN_DwmIsCompositionEnabled	TT_pfnDwmIsCompositionEnabled;
extern PFN_DwmGetWindowAttribute		TT_pfnDwmGetWindowAttribute;

//---------------------------------------------------------------------------------------------------

extern DWORD	TT_dwTimerValue1;			//	Possible values (in milliseconds) from
extern DWORD	TT_dwTimerValue2;			//	 'TT_REG_VAL__Timer_Value__Min'
extern DWORD	TT_dwTimerValue3;			//	 to 'TT_REG_VAL__Timer_Value__Max'.

extern DWORD	TT_dwTimerUnit1;			//	Possible values from
extern DWORD	TT_dwTimerUnit2;			//	 'TT_REG_VAL__Timer_Unit__FIRST_VALUE'
extern DWORD	TT_dwTimerUnit3;			//	 to 'TT_REG_VAL__Timer_Unit__LAST_VALUE'.

extern DWORD	TT_dwTimerEvent1;			//	Possible values from
extern DWORD	TT_dwTimerEvent2;			//	 'TT_REG_VAL__Timer_Event__FIRST_VALUE'
extern DWORD	TT_dwTimerEvent3;			//	 to 'TT_REG_VAL__Timer_Event__LAST_VALUE'.

extern DWORD	TT_dwTimerStarted1;		//	Internal use.  Value stored in milliseconds.
extern DWORD	TT_dwTimerStarted2;		//	Internal use.  Value stored in milliseconds.
extern DWORD	TT_dwTimerStarted3;		//	Internal use.  Value stored in milliseconds.

extern DWORD	TT_dwCountDownValue1;	//	Internal use.  Value stored in seconds.
extern DWORD	TT_dwCountDownValue2;	//	Internal use.  Value stored in seconds.
extern DWORD	TT_dwCountDownValue3;	//	Internal use.  Value stored in seconds.

extern bool		TT_bIsTimerStarted1;		//	Internal use.
extern bool		TT_bIsTimerStarted2;		//	Internal use.
extern bool		TT_bIsTimerStarted3;		//	Internal use.

extern bool		TT_bIsEventTriggered1;	//	Internal use.
extern bool		TT_bIsEventTriggered2;	//	Internal use.
extern bool		TT_bIsEventTriggered3;	//	Internal use.

extern bool		TT_bIsEventCalled1;		//	Internal use.  Used to prevents the triggered event to be called more than once per countdown.
extern bool		TT_bIsEventCalled2;		//	Internal use.	Used to prevents the triggered event to be called more than once per countdown.
extern bool		TT_bIsEventCalled3;		//	Internal use.	Used to prevents the triggered event to be called more than once per countdown.

extern bool		TT_bIsKeepWndOnTop;
extern bool		TT_bIsShowInTitleBar;
extern bool		TT_bIsFlashWndOnTimerUp;
extern bool		TT_bIsUseAltIconOnTimerUp;
extern bool		TT_bIsDisplaySmartCursors;

extern TCHAR	TT_szTimerLabel1[TT_TimerLabel_MaxBufCnt];
extern TCHAR	TT_szTimerLabel2[TT_TimerLabel_MaxBufCnt];
extern TCHAR	TT_szTimerLabel3[TT_TimerLabel_MaxBufCnt];

extern TCHAR	TT_szExtSndLabel1[TT_ExtSndLabel_MaxBufCnt];
extern TCHAR	TT_szExtSndLabel2[TT_ExtSndLabel_MaxBufCnt];
extern TCHAR	TT_szExtSndLabel3[TT_ExtSndLabel_MaxBufCnt];

extern TCHAR	TT_szExtSndFileName1[TT_ExtSndFileName_MaxBufCnt];
extern TCHAR	TT_szExtSndFileName2[TT_ExtSndFileName_MaxBufCnt];
extern TCHAR	TT_szExtSndFileName3[TT_ExtSndFileName_MaxBufCnt];

extern TCHAR	TT_szOpenFileLabel1[TT_OpenFileLabel_MaxBufCnt];
extern TCHAR	TT_szOpenFileLabel2[TT_OpenFileLabel_MaxBufCnt];
extern TCHAR	TT_szOpenFileLabel3[TT_OpenFileLabel_MaxBufCnt];

extern TCHAR	TT_szOpenFileName1[TT_OpenFileName_MaxBufCnt];
extern TCHAR	TT_szOpenFileName2[TT_OpenFileName_MaxBufCnt];
extern TCHAR	TT_szOpenFileName3[TT_OpenFileName_MaxBufCnt];

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////

#define	TT_REG_KEY__ADELUC				_T("Software\\Adeluc")
#define	TT_REG_KEY__ADELUC_TTn			TT_REG_KEY__ADELUC _T("\\Three Timers V%u")		//	Used to create 'TT_strREG_KEY__ADELUC_TTn'. 

#define	TT_REG_KEY__MainWindow			_T("MainWindow")
#define	TT_REG_KEY__MonitorRectangle	_T("MonitorRectangle(%ld,%ld,%ld,%ld)")

#define 	TT_REG_VAR__X						_T("X")
#define 	TT_REG_VAR__Y						_T("Y")
#define 	TT_REG_VAR__CX						_T("CX")
#define 	TT_REG_VAR__CY						_T("CY")

//------------------------------------------------

#define	TT_REG_KEY__Timer__							_T("Timer%02u")

#define 	TT_REG_VAR__Timer_Label						_T("Label")

#define 	TT_REG_VAR__Timer_Value						_T("Value")
//#define 	TT_REG_VAL__Timer_Value__Seconds_Min	1
//#define 	TT_REG_VAL__Timer_Value__Seconds_Max	2147483
//#define 	TT_REG_VAL__Timer_Value__Minutes_Min	1
//#define 	TT_REG_VAL__Timer_Value__Minutes_Max	35491
//#define 	TT_REG_VAL__Timer_Value__Hours_Min		1
//#define 	TT_REG_VAL__Timer_Value__Hours_Max		596
//#define 	TT_REG_VAL__Timer_Value__DFLT_VALUE_1	90		//	Value by default for timer #1.
//#define 	TT_REG_VAL__Timer_Value__DFLT_VALUE_2	5		//	Value by default for timer #2.
//#define 	TT_REG_VAL__Timer_Value__DFLT_VALUE_3	1		//	Value by default for timer #3.
#define 	TT_REG_VAL__Timer_Value__Min				1000			//	Value in milliseconds equals to 1 second.
#define 	TT_REG_VAL__Timer_Value__Max				2145600000	//	Value in milliseconds equals to 596 hours.
#define 	TT_REG_VAL__Timer_Value__DFLT_VALUE_1	90000			//	Value in milliseconds equals to 90 seconds.  Default for timer #1.
#define 	TT_REG_VAL__Timer_Value__DFLT_VALUE_2	300000		//	Value in milliseconds equals to 5 minutes.   Default for timer #2.
#define 	TT_REG_VAL__Timer_Value__DFLT_VALUE_3	3600000		//	Value in milliseconds equals to 1 hour.	   Default for timer #1.

#define 	TT_REG_VAR__Timer_Unit						_T("Unit")
#define 	TT_REG_VAL__Timer_Unit__Seconds			1
#define 	TT_REG_VAL__Timer_Unit__Minutes			2
#define 	TT_REG_VAL__Timer_Unit__Hours				3
#define 	TT_REG_VAL__Timer_Unit__FIRST_VALUE		TT_REG_VAL__Timer_Unit__Seconds
#define 	TT_REG_VAL__Timer_Unit__LAST_VALUE		TT_REG_VAL__Timer_Unit__Hours
#define 	TT_REG_VAL__Timer_Unit__DFLT_VALUE_1	TT_REG_VAL__Timer_Unit__Seconds	//	Value by default for timer #1.
#define 	TT_REG_VAL__Timer_Unit__DFLT_VALUE_2	TT_REG_VAL__Timer_Unit__Minutes	//	Value by default for timer #2.
#define 	TT_REG_VAL__Timer_Unit__DFLT_VALUE_3	TT_REG_VAL__Timer_Unit__Hours		//	Value by default for timer #3.

#define 	TT_REG_VAR__Timer_Event						_T("Event")
#define 	TT_REG_VAL__Timer_Event__BuiltInSnd1	1					//	'IDR_BUILT_IN_EVENT_SND_1_WAVE'
#define 	TT_REG_VAL__Timer_Event__BuiltInSnd2	2					//	'IDR_BUILT_IN_EVENT_SND_2_WAVE'
#define 	TT_REG_VAL__Timer_Event__BuiltInSnd3	3					//	'IDR_BUILT_IN_EVENT_SND_3_WAVE'
#define 	TT_REG_VAL__Timer_Event__ExtSnd1			4
#define 	TT_REG_VAL__Timer_Event__ExtSnd2			5
#define 	TT_REG_VAL__Timer_Event__ExtSnd3			6
#define 	TT_REG_VAL__Timer_Event__OpenFile1		7
#define 	TT_REG_VAL__Timer_Event__OpenFile2		8
#define 	TT_REG_VAL__Timer_Event__OpenFile3		9
#define 	TT_REG_VAL__Timer_Event__FIRST_VALUE	TT_REG_VAL__Timer_Event__BuiltInSnd1
#define 	TT_REG_VAL__Timer_Event__LAST_VALUE		TT_REG_VAL__Timer_Event__OpenFile3
#define 	TT_REG_VAL__Timer_Event__DFLT_VALUE_1	TT_REG_VAL__Timer_Event__BuiltInSnd1		//	Value by default for timer #1.
#define 	TT_REG_VAL__Timer_Event__DFLT_VALUE_2	TT_REG_VAL__Timer_Event__BuiltInSnd2		//	Value by default for timer #2.
#define 	TT_REG_VAL__Timer_Event__DFLT_VALUE_3	TT_REG_VAL__Timer_Event__BuiltInSnd3		//	Value by default for timer #3.

//------------------------------------------------

#define 	TT_REG_KEY__ExternalSound__		_T("ExternalSound%02u")

#define 	TT_REG_VAR__ExtSnd_Label			_T("Label")
#define 	TT_REG_VAR__ExtSnd_FileName		_T("FileName")

//------------------------------------------------

#define 	TT_REG_KEY__OpenFile__				_T("OpenFile%02u")

#define 	TT_REG_VAR__OpenFile_Label			_T("Label")
#define 	TT_REG_VAR__OpenFile_FileName		_T("FileName")

//------------------------------------------------

#define 	TT_REG_VAR__KeepWindowOnTop		_T("KeepWindowOnTop")
#define 	TT_REG_VAR__ShowTimerInTitleBar	_T("ShowTimerInTitleBar")
#define 	TT_REG_VAR__FlashWndOnTimerUp		_T("FlashWndOnTimerUp")
#define 	TT_REG_VAR__UseAltIconOnTimerUp	_T("UseAltIconOnTimerUp")
#define 	TT_REG_VAR__DisplaySmartCursors	_T("DisplaySmartCursors")

//---------------------------------------------------------------------------------------------------

extern long TT_RegWriteString( HKEY hRootKey, const char *pcszKey, const char *pcszStringName, const char *pcszString );
extern long TT_RegWriteInteger( HKEY hRootKey, const char *pcszKey, const char *pcszValueName, const int cnValue );
extern long TT_RegReadString( HKEY hRootKey, const char *pcszKey, const char *pcszStringName,
										const char *pcszDefaultString, char *pcszString, unsigned int *punBufferSize );
extern char * TT_RegGetString( HKEY hRootKey, const char *pcszKey, const char *pcszStringName, const char *pcszDefaultString = 0 );
extern long	  TT_RegReadInteger( HKEY hRootKey, const char *pcszKey, const char *pcszValueName, const int cnDefaultValue, int *pnValue );

extern DWORD TT_RegTestKey( HKEY hRootKey, const char *pcszKey, int *pnSubKeyCount = 0,
									 int *pnDefaultValueCount = 0, int *pnNonDefaultValueCount = 0 );

extern void TT_LoadTimerInfoFromRegistry( const unsigned int cunTimerId, LPTSTR pszLabel = NULL, int *pnValue = NULL,
													   int *pnUnitType = NULL, int *pnEventId = NULL );
extern int  TT_SaveTimerInfoToRegistry( const unsigned int cunTimerId, LPCTSTR pcszLabel, const int cnValue,
													 const int cnUnitType, const int cnEventId );

extern void TT_LoadMiscSettingsFromRegistry( bool *pbIsKeepWndOnTop = NULL, bool *pbIsShowInTitleBar = NULL,
						bool *pbIsFlashWndOnTimerUp = NULL, bool *pbIsUseAltIconOnTimerUp = NULL, bool *pbIsDisplaySmartCursors = NULL,
						LPTSTR pszExtSndLabel1 = NULL, LPTSTR pszExtSndFileName1 = NULL, LPTSTR pszExtSndLabel2 = NULL,
						LPTSTR pszExtSndFileName2 = NULL, LPTSTR pszExtSndLabel3 = NULL, LPTSTR pszExtSndFileName3 = NULL,
						LPTSTR pszOpenFileLabel1 = NULL, LPTSTR pszOpenFileName1 = NULL, LPTSTR pszOpenFileLabel2 = NULL,
						LPTSTR pszOpenFileName2 = NULL, LPTSTR pszOpenFileLabel3 = NULL, LPTSTR pszOpenFileName3 = NULL );

extern int TT_SaveMiscSettingsToRegistry( const bool cbIsKeepWndOnTop, const bool cbIsShowInTitleBar,
						const bool cbIsFlashWndOnTimerUp, const bool cbIsUseAltIconOnTimerUp, const bool cbIsDisplaySmartCursors,
						LPCTSTR pcszExtSndLabel1 = NULL, LPCTSTR pcszExtSndFileName1 = NULL, LPCTSTR pcszExtSndLabel2 = NULL,
						LPCTSTR pcszExtSndFileName2 = NULL, LPCTSTR pcszExtSndLabel3 = NULL, LPCTSTR pcszExtSndFileName3 = NULL,
						LPCTSTR pcszOpenFileLabel1 = NULL, LPCTSTR pcszOpenFileName1 = NULL, LPCTSTR pcszOpenFileLabel2 = NULL,
						LPCTSTR pcszOpenFileName2 = NULL, LPCTSTR pcszOpenFileLabel3 = NULL, LPCTSTR pcszOpenFileName3 = NULL );

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////

#define	TT_MINSTRBUF__VERSION		(5+1+5+1+5+1+5+EOS_CHAR_COUNT)	

extern bool TT_SHGetVersionNumbers( LPCTSTR pcszFileName, unsigned __int64 *pun64FileVersion = 0, LPTSTR pszFileVersion = 0,
												unsigned __int64 *pun64ProductVersion = 0, LPTSTR pszProductVersion = 0 );

inline unsigned short TT_SHGetVersionMajor(	  const unsigned __int64 cun64Version ) { return( HIWORD( cun64Version >> 32 ) ); }
inline unsigned short TT_SHGetVersionMinor(	  const unsigned __int64 cun64Version ) { return( LOWORD( cun64Version >> 32 ) ); }
inline unsigned short TT_SHGetVersionBuild(	  const unsigned __int64 cun64Version ) { return( HIWORD( cun64Version		  ) ); }
inline unsigned short TT_SHGetVersionRevision( const unsigned __int64 cun64Version ) { return( LOWORD( cun64Version		  ) ); }

inline void TT_SHCreateVersionNumber( LPTSTR pcszVersion, const unsigned __int64 cun64Version )
{	//	Buffer pointed by 'pcszVersion' must contain enough space for 'TT_MINSTRBUF__VERSION' characters, NULL character included.
	_stprintf( pcszVersion, _T("%hu.%hu.%hu.%hu"), TT_SHGetVersionMajor( cun64Version ), TT_SHGetVersionMinor( cun64Version ),
																  TT_SHGetVersionBuild( cun64Version ), TT_SHGetVersionRevision( cun64Version ) );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////

extern bool				TT_GetWindowBoundsRect( HWND hWnd, LPRECT lpRect );
extern bool				TT_IsAeroEnabled();

extern bool				TT_GetMonitorAndWorkAreaInfoFromRect( const CRect & rcrectWindow, CRect *prectWorkArea = 0,
																			  CRect *prectMonitor = 0, LPMONITORINFOEX pMonitorInfoEx = 0,
																			  const DWORD cdwFlags = MONITOR_DEFAULTTONEAREST );

extern void				TT_CenterWindow( HWND hwndChild, HWND hwndParent );
extern bool				TT_PathAddQuoteSpaces( LPTSTR pszPath, const bool cbAddQuotesEvenIfEmpty = TRUE );
extern CString			TT_GetWindowText( HWND hwnd );
extern void				TT_TrimStringLeft( LPTSTR pszString );
extern void				TT_TrimStringRight( LPTSTR pszString );
extern void				TT_TrimString( LPTSTR pszString );
extern bool				TT_BIT_GetDfltValues_Notepad( CString *pstrCommandLine = NULL, CString *pstrWindowClassName = NULL );

extern bool				TT_InstallPrivateFonts();
extern void				TT_UninstallPrivateFonts();

extern bool				TT_LoadScreenInfoFromRegistry( LPCTSTR pcszScreenRegKeyName, const CRect & rcrectScreenDefault,
														 CRect *prectScreen = 0, CRect *prectWorkArea = 0, CRect *prectMonitor = 0,
														 const bool cbCenterInWorkArea = FALSE, const bool cbAlignToWorkAreaEdges = TRUE );

extern bool				TT_SaveScreenInfoToRegistry( LPCTSTR pcszScreenRegKeyName, HWND hwndScreen, CRect *prectScreen = 0,
																  CRect *prectWorkArea = 0, CRect *prectMonitor = 0 );

extern bool				TT_BrowseWebpageLink( LPCTSTR pcszWebpageLink, HWND hwndParent = 0, bool bPromptOnError = TRUE );
extern HBITMAP			TT_Create32BitsBitmapFrom32BitsIcon( HICON hiconSource, const JCH_Pixel cpixCanvasColor );
extern bool				TT_CreateFolder( LPCTSTR pcszFolderPath, LPSECURITY_ATTRIBUTES lpSecurityAttributes = 0 );

//---------------------------------------------------------------------------------------------------

extern BOOL				TT_StartInstance( HINSTANCE hInstance, int nCmdShow );

extern int				TT_GetTimerValue( LPCTSTR pcszTimerValue, unsigned int *punTimerValue,
													const unsigned int cunTimerUnit = TT_REG_VAL__Timer_Unit__Seconds );
extern CString			TT_FormatTimerValue( const unsigned int cunTimerValue,
													   const unsigned int cunTimerUnit = TT_REG_VAL__Timer_Unit__Seconds,
														const bool cbKeepHeadingZero = FALSE );

extern unsigned int	TT_GetTimerUnitFromComboBox( HWND hwndDlg, const int cnComboBoxId );
extern unsigned int	TT_GetEventIdFromComboBox( HWND hwndDlg, const int cnComboBoxId );
extern bool				TT_PopulateTimerEventComboBox( HWND hwndDlg, const int cnComboBoxId, const int cnSelectedEvent = 0 );
extern bool				TT_IsMouseOver_TimerGroupLabel( const int cnPosX, const int cnPosY, HWND hwndDlg,
																	  const int cnTimerGroupId, const int cnTimerStartStopBtnId );

extern bool				TT_ExecuteOpenFile( LPCTSTR pcszOpenFileName );
extern bool				TT_ExecuteEventId( HWND hwndDlg, const unsigned int cunEventId );
extern void				TT_UpdateWindowTitle( HWND hwndDlg, const bool cbIsClearTitleBarOnly = FALSE );

extern HRESULT			TT_CreateLink( LPCTSTR pcszLinkPath, LPCTSTR pcszFilePath, LPCTSTR pcszWorkDir, LPCTSTR pcszArgs,
												LPCTSTR pcszDescription, int nIcon, LPCTSTR pcszIconPath, int nShowCmd );
extern HRESULT			TT_CreateAppIcon( LPCTSTR pcszLinkName, LPCTSTR pcszAbsoluteAppFileName, LPCTSTR pcszStartingFolder,
													LPCTSTR pcszSubMenuFolder, LPCTSTR pcszArgs, LPCTSTR pcszDescription,
													const int cnIcon, const bool cbCreateItOnDesktopInstead );
extern bool				TT_CreateDesktopShortcut( const bool cbPlaySound = TRUE );

extern int				TT_ProcessPopupMenu_TimersMenu( HWND hwndDlg, const bool cbIsShowFunnyExit = FALSE );
extern int				TT_ProcessPopupMenu_TimerGroupLabel( HWND hwndDlg, const int cnPosX, const int cnPosY, const int cnTimerGroupId );
extern int				TT_ProcessPopupMenu_AdvOptions( HWND hwndDlg );

//---------------------------------------------------------------------------------------------------

struct TT_AskFile_Params
{
	DWORD		dwPatch_CDN_INITDONE_Tick;				// Internal use.
	bool		bPatch_CDN_INITDONE_Processed;		// Internal use.

	TT_AskFile_Params() { dwPatch_CDN_INITDONE_Tick = 0;	bPatch_CDN_INITDONE_Processed = FALSE; }
};

extern UINT_PTR CALLBACK TT_AskWaveFile_HookProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );
extern UINT_PTR CALLBACK TT_AskOpenFile_HookProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );

//---------------------------------------------------------------------------------------------------

#define	TT_WM_USER__TimerLabelChanged1	(WM_USER + 0x7BFF - 0)		//	Used to indicate that the Timer Label #1 has been modified.
#define	TT_WM_USER__TimerLabelChanged2	(WM_USER + 0x7BFF - 1)		//	Used to indicate that the Timer Label #2 has been modified.
#define	TT_WM_USER__TimerLabelChanged3	(WM_USER + 0x7BFF - 2)		//	Used to indicate that the Timer Label #3 has been modified.

extern INT_PTR	CALLBACK	DlgThreeTimersProc( HWND, UINT, WPARAM, LPARAM );

//------------------------------------------------

extern INT_PTR CALLBACK	DlgSettingsProc( HWND, UINT, WPARAM, LPARAM );
extern INT_PTR CALLBACK	DlgAboutProc( HWND, UINT, WPARAM, LPARAM );

//---------------------------------------------------------------------------------------------------

#define	TT_IDC_MTLTW_TIMER_LABEL_ED						101
#define	TT_WM_USER__RESTORE_INITIAL_TIMER_LABEL		(WM_USER + 0x7BFF - 0)
#define	TT_WM_USER__USER_HAS_PRESSED_THE_ENTER_KEY	(WM_USER + 0x7BFF - 1)

struct TT_ModifyTimerLabelTinyWnd
{
	HWND				m_hwndDialogBox;										//	Must be initialized.
	unsigned int	m_unMsgUsedToUpdate;									//	Must be initialized to 'TT_WM_USER__TimerLabelChanged1',
																					//	 'TT_WM_USER__TimerLabelChanged2' or 'TT_WM_USER__TimerLabelChanged3'.
	int				m_nTimerGroupId;										//	Must be initialized.
	int				m_nTimerStartStopBtnId;								//	Must be initialized.
	int				m_nTimerValueEditId;									//	Must be initialized.
	int				m_nTimerLabelDfltStrId;								//	Must be initialized.
	TCHAR			 (*m_pszTimerLabel)[TT_TimerLabel_MaxBufCnt];	//	Must be initialized.
	HWND				m_hwndEditControl;		//	Internal use only.
	HFONT				m_hfontEditControl;		//	Internal use only.
	bool				m_bIsEnterKeyPressed;	//	Internal use only.

	TT_ModifyTimerLabelTinyWnd()
	{
		m_hwndDialogBox		  = 0;
		m_unMsgUsedToUpdate	  = 0;
		m_nTimerGroupId		  = 0;
		m_nTimerStartStopBtnId = 0;
		m_nTimerValueEditId	  = 0;
		m_nTimerLabelDfltStrId = 0;
		m_pszTimerLabel		  = NULL;
		m_hwndEditControl		  = 0;
		m_hfontEditControl	  = 0;
		m_bIsEnterKeyPressed	  = FALSE;
	}
};

extern LRESULT CALLBACK TT_ModifyTimerLabelTinyWndProc_HookProc_EditCtrl( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
extern LRESULT CALLBACK TT_ModifyTimerLabelTinyWndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

extern bool TT_RegisterClass_ThreeTimers_ModifyTimerLabelTinyWnd( HINSTANCE hInstance );
extern bool TT_AskModifyTimerLabel( HWND hwndDlg, const unsigned int cunMsgUsedToUpdate );

/////////////////////////////////////////////////////////////////////////////////////////////////////
