/////////////////////////////////////////////////////////////////////////////////////////////////////
//																																	//
//	Coded by www.decotechpro.com, all rights reserved.  Created: 1999-01-01  Modified: 2016-03-21	//
//																																	//
// JCH_PixelMap.h : Header of JCH_PixelMap class & functions.													//
//																																	//
/////////////////////////////////////////////////////////////////////////////////////////////////////

//#include "TT_PixelMap.h"
#pragma once

#include <afxwin.h>
#include "TT_Global.h"

#include "TT_Pixel.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////

class JCH_PixelMap
{
protected:

	JCH_Pixel	  *m_pFirstPixel;		// PixelMap is stored in memory from bottom line to top line.
	unsigned int	m_unMemorySize;	// Memory used to store all pixels.
	BITMAPINFO 		m_BitMapInfo;

public:

	enum ResolutionDefaultValue {
		rdvPixelsPerScreenInch = 75, rdvPixelsPerScreenMeter = 2952 };

   //------------------------------------------------

	JCH_PixelMap();
   
   //------------------------------------------------
   
   JCH_PixelMap( const JCH_PixelMap & rcPixelMap );	//	throw( CMemoryException * )
   
   //------------------------------------------------
   
   JCH_PixelMap & operator = ( const JCH_PixelMap & rcPixelMap );	//	throw( CMemoryException * )
   
   //------------------------------------------------
   
	~JCH_PixelMap() { FreePixels(); }
	
	//------------------------------------------------

	bool AllocatePixels( const int cnWidth, const int cnHeight, 
								const bool cbFillNewArea = FALSE, const JCH_Pixel cpixFillValue = 0xFFFFFFFF );

	void FreePixels()	//	Free the memory used to store all the pixels.
	{
		if ( m_pFirstPixel != 0 ) delete [] m_pFirstPixel;

		m_pFirstPixel  = 0;
		m_unMemorySize = 0;				
		m_BitMapInfo.bmiHeader.biWidth = m_BitMapInfo.bmiHeader.biHeight = 0;				
	}

	//------------------------------------------------

	bool AttachMemory( JCH_Pixel *pFirstPixel, unsigned int unMemorySize, const int cnWidth, const int cnHeight,
											  const int cnXPelsPerMeter = -1, const int cnYPelsPerMeter = -1 );

	JCH_Pixel * DetachMemory( unsigned int *punMemorySize = 0, int *pnWidth = 0, int *pnHeight = 0,
																		int *pnXPelsPerMeter = 0, int *pnYPelsPerMeter = 0 );

	//------------------------------------------------
	
	bool operator == ( const JCH_PixelMap & rcpixmapOther ) const
	{
      return( (((m_unMemorySize == rcpixmapOther.m_unMemorySize) &&
					(memcmp( &m_BitMapInfo, &rcpixmapOther.m_BitMapInfo, sizeof( BITMAPINFO ) ) == 0) &&
					(memcmp( m_pFirstPixel, rcpixmapOther.m_pFirstPixel, m_unMemorySize ) == 0)) ? TRUE : FALSE) );
   }
	
	bool operator != ( const JCH_PixelMap & rcpixmapOther ) const
	{
		return( ((operator == ( rcpixmapOther ) != FALSE) ? FALSE : TRUE) );
   }

	//------------------------------------------------

	void Fill( const CRect cRectangle, const JCH_Pixel cpixFillValue );

	//

	void Fill( const JCH_Pixel cpixFillValue )
	{
		if ( (m_pFirstPixel != 0) ) Fill( CRect( 0, 0, GetWidth(), GetHeight() ), cpixFillValue );
	}

	//------------------------------------------------

	void AlphaBlend( const int cnSourcePositionX, const int cnSourcePositionY, const int cnTargetPositionX,
						  const int cnTargetPositionY, const int cnWidth, const int cnHeight, 
						  JCH_Pixel *ppixTargetFirstPixel, const int cnTargetTotalWidth,
						  const int cnTargetTotalHeight, const bool cbSourceIsPremultiplied = FALSE,
						  const unsigned int cunSourceConstantAlpha = JCH_PIXEL_CHANNEL_MAX_VAL,
						  const bool cbIgnoreSourceAlphaChannel = FALSE ) const;

	void AlphaBlend( const int cnSourcePositionX, const int cnSourcePositionY, const int cnTargetPositionX,
						  const int cnTargetPositionY, const int cnWidth, const int cnHeight, 
						  JCH_PixelMap & rTargetPixelMap, const bool cbSourceIsPremultiplied = FALSE,
						  const unsigned int cunSourceConstantAlpha = JCH_PIXEL_CHANNEL_MAX_VAL,
						  const bool cbIgnoreSourceAlphaChannel = FALSE ) const
	{
		AlphaBlend( cnSourcePositionX, cnSourcePositionY, cnTargetPositionX,
						cnTargetPositionY, cnWidth, cnHeight, rTargetPixelMap.m_pFirstPixel, 
						rTargetPixelMap.m_BitMapInfo.bmiHeader.biWidth, rTargetPixelMap.m_BitMapInfo.bmiHeader.biHeight,
						cbSourceIsPremultiplied, cunSourceConstantAlpha, cbIgnoreSourceAlphaChannel );
	}

	//------------------------------------------------

	unsigned int GetMemorySize() const { return( m_unMemorySize ); }
	int GetWidth() const { return( m_BitMapInfo.bmiHeader.biWidth ); }
	int GetHeight() const { return( m_BitMapInfo.bmiHeader.biHeight ); }

	int GetXPelsPerMeter() const { return( m_BitMapInfo.bmiHeader.biXPelsPerMeter ); }
	int SetXPelsPerMeter( const int cnNewValue )
	{
		int nTmp = m_BitMapInfo.bmiHeader.biXPelsPerMeter;
		m_BitMapInfo.bmiHeader.biXPelsPerMeter = cnNewValue;
		return( nTmp );
	}

	int GetYPelsPerMeter() const { return( m_BitMapInfo.bmiHeader.biYPelsPerMeter ); }
	int SetYPelsPerMeter( const int cnNewValue )
	{
		int nTmp = m_BitMapInfo.bmiHeader.biYPelsPerMeter;
		m_BitMapInfo.bmiHeader.biYPelsPerMeter = cnNewValue;
		return( nTmp );
	}

	// Be careful when using this pointer because the memory it points can be freed by other functions.
	JCH_Pixel * GetFirstPixelAddress() const { return( m_pFirstPixel ); }

	// Never modify directly this BITMAPINFO structure otherwise
	//	 the other member variables will be out of sync.
	const BITMAPINFO * GetBitMapInfoAddress() const { return( &m_BitMapInfo ); }

	//------------------------------------------------

	bool IsValid() const
	{
		return( ((m_pFirstPixel != 0) && (m_unMemorySize != 0) &&
					(m_BitMapInfo.bmiHeader.biWidth > 0) && (m_BitMapInfo.bmiHeader.biHeight > 0)) );
	}
};

/////////////////////////////////////////////////////////////////////////////////////////////////////
