/////////////////////////////////////////////////////////////////////////////////////////////////////
//																																	//
//	Coded by www.decotechpro.com, all rights reserved.  Created: 1999-01-01  Modified: 2016-03-22	//
//																																	//
// JCH_Global.h : Global declarations.																					//
//																																	//
/////////////////////////////////////////////////////////////////////////////////////////////////////

//#include "TT_Global.h"
#pragma once

/////////////////////////////////////////////////////////////////////////////////////////////////////

#define JCH_LIB_VERSION_MAJOR			2
#define JCH_LIB_VERSION_MINOR			2
#define JCH_LIB_VERSION_BUILD			1		//	0=Alpha, 1=Beta, 2=ReleaseCandidate, 3=Release.  (I can't see the day it will be 3!)
#define JCH_LIB_VERSION_REVISION		1

/////////////////////////////////////////////////////////////////////////////////////////////////////

	

/////////////////////////////////////////////////////////////////////////////////////////////////////

#if !defined(FOREVER)
#define FOREVER for(;;)
#endif // #if !defined(FOREVER)

#if !defined(EOS_CHAR_COUNT)
#define  EOS_CHAR_COUNT		1	// Used in code to clearly indicate that 1 character space is reserved for the EndOfString NULL terminator.
#endif // #if !defined(EOS_CHAR_COUNT)

#if !defined(EMPTY_STR_FUNCTIONS_DEFINED)
#define	EMPTY_STR_FUNCTIONS_DEFINED
inline void _tcsEmpty( LPTSTR psz ) { psz[0] = _T('\0'); }
inline bool _tcsIsEmpty( LPCTSTR pcsz ) { return( (pcsz[0] == _T('\0')) ); }
inline void _tcsEmpty_s( LPTSTR psz ) { if ( psz != 0 ) psz[0] = _T('\0'); }
inline bool _tcsIsEmpty_s( LPCTSTR pcsz ) { return( ((pcsz == 0) ? TRUE : (pcsz[0] == _T('\0'))) ); }
#endif // #if !defined(EMPTY_STR_FUNCTIONS_DEFINED)

#if !defined(JCH_DEBUG_FILL_WITH_0xCC)
#ifdef _DEBUG
#define	JCH_DEBUG_FILL_WITH_0xCC(a)	memset( &(a), 0xCC, sizeof(a) );
#else
#define	JCH_DEBUG_FILL_WITH_0xCC(a)
#endif
#endif // #if !defined(JCH_DEBUG_FILL_WITH_0xCC)

//---------------------------------------------------------------------------------------------------
//	Byte Order Mark of Unicode Transformation Formats.  In the string defines, the NULL terminating
//	 character is not part of the BOM.

#if !defined(JCH_BOM_UTF_DEFINED)
#define	JCH_BOM_UTF_DEFINED
#define	JCH_BOM_UTF8_String		"\xEF\xBB\xBF"			//	Three 8-bit characters.
#define	JCH_BOM_UTF16LE_String	"\xFF\xFE"				//	Two 8-bit characters indicating little endian storage.
#define	JCH_BOM_UTF16BE_String	"\xFE\xFF"				//	Two 8-bit characters indicating big endian storage.
#define	JCH_BOM_UTF32LE_String	"\xFF\xFE\x00\x00"	//	Four 8-bit characters indicating little endian storage.
#define	JCH_BOM_UTF32BE_String	"\x00\x00\xFE\xFF"	//	Four 8-bit characters indicating big endian storage.

#define	JCH_BOM_UTF16_CHAR		0xFEFF		//	A 16-bit character used at the beginning of a text file to indicate the byte order storage.
#define	JCH_BOM_UTF32_CHAR		0x0000FEFF	//	A 32-bit character used at the beginning of a text file to indicate the byte order storage.
#endif // #if !defined(JCH_BOM_UTF_DEFINED)

//---------------------------------------------------------------------------------------------------

#if !defined(JCH_PIX_TO_UINT8)
#define JCH_PIX_TO_UINT8( width_in_pixel, bits_per_pixel ) ((((unsigned __int32)(width_in_pixel) * (bits_per_pixel)) +  7) >> 3)
#endif // !defined(JCH_PIX_TO_UINT8)

#if !defined(JCH_PIX_TO_UINT16)
#define JCH_PIX_TO_UINT16( width_in_pixel, bits_per_pixel ) ((((unsigned __int32)(width_in_pixel) * (bits_per_pixel)) + 15) >> 4)
#endif // !defined(JCH_PIX_TO_UINT16)

#if !defined(JCH_PIX_TO_UINT32)
#define JCH_PIX_TO_UINT32( width_in_pixel, bits_per_pixel ) ((((unsigned __int32)(width_in_pixel) * (bits_per_pixel)) + 31) >> 5)
#endif // !defined(JCH_PIX_TO_UINT32)

//---------------------------------------------------------------------------------------------------

#if !defined(SZ_RGB)
#define SZ_RGB (sizeof( __int8 ) * 3)
#endif

#if !defined(SZ_ARGB)
#define SZ_ARGB (sizeof( __int8 ) * 4)
#endif

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////

#if !defined(JCH_PI4)	// 45 degrees
#define JCH_PI4	0.78539816339744830961566084581987572104929234984378
#endif // !defined(JCH_PI4)	

#if !defined(JCH_PI2)	// 90 degrees
#define JCH_PI2	1.57079632679489661923132169163975144209858469968755
#endif // !defined(JCH_PI2)	

#if !defined(JCH_PI)		// 180 degrees
#define JCH_PI		3.14159265358979323846264338327950288419716939937510
#endif // !defined(JCH_PI)	

#if !defined(JCH_3PI2)	// 270 degrees
#define JCH_3PI2	4.71238898038468985769396507491925432129575409906265
#endif // !defined(JCH_3PI2)	

#if !defined(JCH_2PI)	// 360 degrees
#define JCH_2PI	6.28318530717958647692528676655900576839433879875020
#endif // !defined(JCH_2PI)	

#if !defined(JCH_DEG2RAD)
#define JCH_DEG2RAD( angle ) ((angle) * JCH_PI / 180.0)
#endif // !defined(JCH_DEG2RAD)	

#if !defined(JCH_RAD2DEG)
#define JCH_RAD2DEG( angle ) ((angle) * 180.0 / JCH_PI)
#endif // !defined(JCH_RAD2DEG)	

/////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////
//	The advantage of using these template functions instead of the min(a,b) and max(a,b) macros is that
//	 if a parameter (or both) is an expression, it will not be evaluated twice.  That may be a real
//	 speed issue in a loop of heavy calculation.  Also the macros min(a,b) and max(a,b) defined in
//	 <WinDef.h> may interfere with std::min() and std::max().  So to avoid all those possible troubles
//	 use these template functions or at least use the macros __min(a,b) and __max(a,b) defined in <stdlib.h>.
//	 For the compiler to instanciate a template function, both parameters most be of the same type.
//	 So with parameters of different types, you need to cast one parameter with the type of the other one,
//	 usually the type that you want as the return value.

template <class T> T JCH_Min( T unA, T unB ) { return( ((unA < unB) ? unA : unB) ); }
template <class T> T JCH_Max( T unA, T unB ) { return( ((unA > unB) ? unA : unB) ); }

/////////////////////////////////////////////////////////////////////////////////////////////////////
